<?php

namespace Database\Seeders\Update;

use Illuminate\Database\Seeder;
use App\Models\Admin\PaymentGateway;
use App\Models\Admin\PaymentGatewayCurrency;

class PaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //gateway data
        $perfect_money = PaymentGateway::latest()->first();
        //perfect_money
        if(!PaymentGateway::where('alias','perfect-money')->exists()){
            $payment_gateways_id = $perfect_money->id+2;
            $payment_gateways_code = PaymentGateway::max('code')+5;

            $payment_gateways = array(
                array('id' => $payment_gateways_id,'slug' => 'add-money','code' => $payment_gateways_code,'type' => 'AUTOMATIC','name' => 'Perfect Money','title' => 'Perfect Money Gateway','alias' => 'perfect-money','image' => 'a9f5fc3e-b53c-4fb8-9b9d-301c82b3158c.webp','credentials' => '[{"label":"Alternate Passphrase","placeholder":"Enter Alternate Passphrase","name":"alternate-passphrase","value":"t0d2nbK2ZA92fRTnIFsMTWsHT"},{"label":"EUR Account","placeholder":"Enter EUR Account","name":"eur-account","value":"E39620511"},{"label":"USD Account","placeholder":"Enter USD Account","name":"usd-account","value":"U39903302"}]','supported_currencies' => '["USD","EUR"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => now(),'updated_at' => now())
            );
            PaymentGateway::insert($payment_gateways);
            $payment_gateway_currencies = array(
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Perfect Money EUR','alias' => 'add-money-perfect-money-eur-automatic','currency_code' => 'EUR','currency_symbol' => '€','image' => 'a9f5fc3e-b53c-4fb8-9b9d-301c82b3158c.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '0.92000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Perfect Money USD','alias' => 'add-money-perfect-money-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'a9f5fc3e-b53c-4fb8-9b9d-301c82b3158c.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => now(),'updated_at' => now())
            );
            PaymentGatewayCurrency::insert($payment_gateway_currencies);
        }
        //update razorpay payment gateway
        if(!PaymentGatewayCurrency::where('alias','add-money-razorpay-usd-automatic')->exists()){
            $razor_pay_gateway = PaymentGateway::where('alias','razorpay')->first();
            $razor_pay_gateway->credentials =[
                ["label" => "Key ID", "placeholder" => "Enter Key ID", "name" => "key-id", "value" => "rzp_test_voV4gKUbSxoQez"],
                ["label" => "Secret Key", "placeholder" => "Enter Secret Key", "name" => "secret-key", "value" => "cJltc1jy6evA4Vvh9lTO7SWr"]
            ];
            $razor_pay_gateway->supported_currencies = ["USD","EUR","GBP","SGD","AED","AUD","CAD","CNY","SEK","NZD","MXN","BDT","EGP","HKD","INR","LBP","LKR","MAD","MYR","NGN","NPR","PHP","PKR","QAR","SAR","UZS","GHS"];
            $razor_pay_gateway->save();
            $razor_pay_gateway_id =  $razor_pay_gateway->id;
            $payment_gateway_currencies = array(
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay GHS','alias' => 'add-money-razorpay-ghs-automatic','currency_code' => 'GHS','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '11.90000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay UZS','alias' => 'add-money-razorpay-uzs-automatic','currency_code' => 'UZS','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '12263.46000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay SAR','alias' => 'add-money-razorpay-sar-automatic','currency_code' => 'SAR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '3.75000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay QAR','alias' => 'add-money-razorpay-qar-automatic','currency_code' => 'QAR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '3.64000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay PKR','alias' => 'add-money-razorpay-pkr-automatic','currency_code' => 'PKR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '286.50000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay PHP','alias' => 'add-money-razorpay-php-automatic','currency_code' => 'PHP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '55.79000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay NPR','alias' => 'add-money-razorpay-npr-automatic','currency_code' => 'NPR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '133.25000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay NGN','alias' => 'add-money-razorpay-ngn-automatic','currency_code' => 'NGN','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '780.00000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay MYR','alias' => 'add-money-razorpay-myr-automatic','currency_code' => 'MYR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '4.69000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay MAD','alias' => 'add-money-razorpay-mad-automatic','currency_code' => 'MAD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '10.21000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay LKR','alias' => 'add-money-razorpay-lkr-automatic','currency_code' => 'LKR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '327.00000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay LBP','alias' => 'add-money-razorpay-lbp-automatic','currency_code' => 'LBP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '15000.00000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay HKD','alias' => 'add-money-razorpay-hkd-automatic','currency_code' => 'HKD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '7.81000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay EGP','alias' => 'add-money-razorpay-egp-automatic','currency_code' => 'EGP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '30.85000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay BDT','alias' => 'add-money-razorpay-bdt-automatic','currency_code' => 'BDT','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '110.00000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay MXN','alias' => 'add-money-razorpay-mxn-automatic','currency_code' => 'MXN','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '17.57000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay NZD','alias' => 'add-money-razorpay-nzd-automatic','currency_code' => 'NZD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.69000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay SEK','alias' => 'add-money-razorpay-sek-automatic','currency_code' => 'SEK','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '10.89000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay CNY','alias' => 'add-money-razorpay-cny-automatic','currency_code' => 'CNY','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '7.29000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay CAD','alias' => 'add-money-razorpay-cad-automatic','currency_code' => 'CAD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.38000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay AUD','alias' => 'add-money-razorpay-aud-automatic','currency_code' => 'AUD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.56000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay AED','alias' => 'add-money-razorpay-aed-automatic','currency_code' => 'AED','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '3.67000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay SGD','alias' => 'add-money-razorpay-sgd-automatic','currency_code' => 'SGD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.36000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay GBP','alias' => 'add-money-razorpay-gbp-automatic','currency_code' => 'GBP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '0.82000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay EUR','alias' => 'add-money-razorpay-eur-automatic','currency_code' => 'EUR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '0.94000000','created_at' => now(),'updated_at' => now()),
                array('payment_gateway_id' => $razor_pay_gateway_id,'name' => 'Razorpay USD','alias' => 'add-money-razorpay-usd-automatic','currency_code' => 'USD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => now(),'updated_at' => now()),
            );
            PaymentGatewayCurrency::insert($payment_gateway_currencies);
        }
        $perfect_money = PaymentGateway::latest()->first();
        //add Pagadito Gateway
        if(!PaymentGateway::where('alias','pagadito')->exists()){
            $payment_gateways_id = $perfect_money->id+2;
            $payment_gateways_code = PaymentGateway::max('code')+5;

            $payment_gateways = array(
                array('id' => $payment_gateways_id,'slug' => 'add-money','code' => '245','type' => 'AUTOMATIC','name' => 'Pagadito','title' => 'Pagadito Payment gateway','alias' => 'pagadito','image' => 'seeder/pagadito.webp','credentials' => '[{"label":"UID","placeholder":"Enter UID","name":"uid","value":"b73eb3fa1dc8bea4b4363322c906a8fd"},{"label":"WSK","placeholder":"Enter WSK","name":"wsk","value":"dc843ff5865bac2858ad8f23af081256"},{"label":"base_url","placeholder":"Enter base_url","name":"base_url","value":"https:\\/\\/sandbox.pagadito.com"}]','supported_currencies' => '["USD","HNL","CRC","DOP","GTQ","NIO","PAB"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' =>  now(),'updated_at' =>  now())
            );
            PaymentGateway::insert($payment_gateways);
            $payment_gateway_currencies = array(
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Pagadito USD','alias' => 'add-money-pagadito-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Pagadito HNL','alias' => 'add-money-pagadito-hnl-automatic','currency_code' => 'HNL','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '0.00000000','max_limit' => '0.00000000','percent_charge' => '0.00000000','fixed_charge' => '0.00000000','rate' => '24.62000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Pagadito CRC','alias' => 'add-money-pagadito-crc-automatic','currency_code' => 'CRC','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '518.12000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Pagadito DOP','alias' => 'add-money-pagadito-dop-automatic','currency_code' => 'DOP','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '58.02801200','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Pagadito GTQ','alias' => 'add-money-pagadito-gtq-automatic','currency_code' => 'GTQ','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '7.81000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Pagadito NIO','alias' => 'add-money-pagadito-nio-automatic','currency_code' => 'NIO','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '36.54000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
                array('payment_gateway_id' => $payment_gateways_id,'name' => 'Pagadito PAB','alias' => 'add-money-pagadito-pab-automatic','currency_code' => 'PAB','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21')
            );
            PaymentGatewayCurrency::insert($payment_gateway_currencies);
        }


    }
}
